.section regular,__TEXT
.align 4
.globl _ppc_zoom	;// name of the function to call by C program

; notes :
; this routine dynamically computes and applies a zoom filter
; do not use r0, r1, r2 and r3
; registers are not saved so the call to this function must be the last thing done in the calling C function

; parameters :
; r3  <=> unsigned int * frompixmap
; r4  <=> unsigned int * topixmap
; r5  <=> unsigned int sizeX (in pixels)
; r6  <=> unsigned int sizeY (in pixels)
; r7  <=> unsigned int * brutS
; r8  <=> unsigned int * brutD
; r9  <=> unsigned int buffratio
; r10 <=> 

; globals after init
; r3  <=> frompixmap - 1 byte needed for preincremental fetch (replaces r3)
; r4  <=> topixmap - 1 byte needed for preincremental fetch (replaces r4)
; r5 <=> ax = x max in 16th of pixels (replaces old r5)
; r6 <=> ay = y max in 16th of pixels (replaces old r6)
; r15 <=> row size in bytes
; r16 <=> 0xFF00FF (mask for parallel 32 bits pixs computing)
; r30 <=> brutS - 1 byte needed for preincremental fetch (replaces r7)
; r31 <=> brutD - 1 byte needed for preincremental fetch (replaces r8)

; free reg
; r14
; r13


_ppc_zoom:

stw r15,-68(r1)
stw r16,-64(r1)
stw r17,-60(r1)
stw r18,-56(r1)
stw r19,-52(r1)
stw r20,-48(r1)
stw r21,-44(r1)
stw r22,-40(r1)
stw r23,-36(r1)
stw r24,-32(r1)
stw r25,-28(r1)
stw r26,-24(r1)
stw r27,-20(r1)
stw r28,-16(r1)
stw r29,-12(r1)
stw r30,-8(r1)
stw r31,-4(r1)


; init
mr      r11,r10
li      r16,0xFF
mullw   r17,r5,r6   ; number of pixels to compute
subi    r30,r8,4
mulli	r15,r5,4
srwi    r19,r15,2
addis   r16,r16,0xFF
subi    r5,r5,1
subi    r6,r6,1
mtspr	ctr,r17     ; number of pixels to compute
subi    r31,r7,4
subi    r4,r4,4
mulli   r5,r5,16
mulli   r6,r6,16

1:

; computes dynamically the position to fetch
lwzu	r8,4(r30)    ; px2
lwzu	r17,4(r31)   ; px
lwzu	r10,4(r30)   ; py2
lwzu	r29,4(r31)   ; py
sub     r8,r8,r17
sub     r10,r10,r29
mullw   r8,r8,r9
mullw   r10,r10,r9
srawi   r8,r8,16
srawi   r10,r10,16
add     r17,r17,r8
add     r29,r29,r10


; if px>ax or py>ay or px<0 or py <0 goto outofrange
cmpl    cr1,0,r17,r5


; computes the attenuation coeffs and the original point address
andi.   r10,r29,0x0F  ;coefv
cmpl    cr2,0,r29,r6
andi.   r8,r17,0x0F   ;coefh
srawi   r29,r29,4     ; pos computing
bgt-	cr1,Loutofrange
srawi   r17,r17,4     ; pos computing
mulli   r10,r10,4
bgt-	cr2,Loutofrange
mullw   r29, r29,r19  ; pos computing


mulli   r8,r8,4*16
add     r17,r17,r29    ; pos computing
add     r10,r10,r8
slwi    r17,r17,2      ; pos computing
add     r10,r10,r11
lwz     r10,0(r10)
add	r17,r17,r3     ; pos computing
andi.   r21,r10,0xFF
srwi    r10,r10,8
;li	r25,0
lwz	r25,0(r17)		; chargement de col1 ->r25
andi.   r22,r10,0xFF
srwi    r10,r10,8
and	r8, r25,r16
;li	r26,0
lwz	r26,4(r17)		; chargement de col2 ->r26
andi.   r23,r10,0xFF
mullw	r8, r8, r21
srwi    r10,r10,8
andi.	r18,r25,0xFF00
add	r17,r17,r15
andi.   r24,r10,0xFF



; computes final pixel color
and	r10,r26,r16
;li	r27,0
lwz	r27,0(r17)		; chargement de col3 ->r27
mullw	r18,r18,r21
mullw	r10,r10,r22
andi.	r29,r26,0xFF00
;li	r28,0
lwz	r28,4(r17)		; chargement de col4 ->r28
add	r8, r8, r10
mullw	r29,r29,r22
and	r10,r27,r16
add	r18,r18,r29
mullw	r10,r10,r23
andi.	r29,r27,0xFF00
add	r8, r8,r10
mullw	r29,r29,r23
and	r10,r28,r16
add	r18,r18,r29
mullw	r10,r10,r24
andi.	r29,r28,0xFF00
add	r8, r8, r10
mullw	r29,r29,r24

srawi	r7, r8, 8
add	r18,r18,r29
and	r7, r7, r16

srawi	r18, r18, 8
andi.   r18,r18,0xFF00
or	r7, r18, r7
stwu	r7,4(r4)
bdnz+	1boucle
b       Lend;goto end


; if out of range
Loutofrange:
li      r7,0
stwu	r7,4(r4)
bdnz+	1boucle


;end:
Lend:

lwz r15,-68(r1)
lwz r16,-64(r1)
lwz r17,-60(r1)
lwz r18,-56(r1)
lwz r19,-52(r1)
lwz r20,-48(r1)
lwz r21,-44(r1)
lwz r22,-40(r1)
lwz r23,-36(r1)
lwz r24,-32(r1)
lwz r25,-28(r1)
lwz r26,-24(r1)
lwz r27,-20(r1)
lwz r28,-16(r1)
lwz r29,-12(r1)
lwz r30,-8(r1)
lwz r31,-4(r1)


blr